/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.tileentity;

import com.google.common.collect.ImmutableList;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.CrystalStationContainer;
import dev.toma.gunsrpg.common.init.ModBlockEntities;
import dev.toma.gunsrpg.common.item.perk.Crystal;
import dev.toma.gunsrpg.common.item.perk.CrystalItem;
import dev.toma.gunsrpg.common.item.perk.PerkItem;
import dev.toma.gunsrpg.common.item.perk.PerkVariant;
import dev.toma.gunsrpg.common.tileentity.InventoryTileEntity;
import dev.toma.gunsrpg.resource.perks.FusionConfiguration;
import dev.toma.gunsrpg.resource.perks.PerkConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CrystalFusionStationTileEntity
extends InventoryTileEntity {
    public static final int OUTPUT = 0;
    public static final int[] INPUTS = new int[]{1, 2};
    public static final int[] ORBS = new int[]{3, 4, 5};

    protected CrystalFusionStationTileEntity(TileEntityType<CrystalFusionStationTileEntity> type) {
        super(type);
    }

    public CrystalFusionStationTileEntity() {
        this((TileEntityType<CrystalFusionStationTileEntity>)((TileEntityType)ModBlockEntities.CRYSTAL_FUSION.get()));
    }

    @Override
    public IItemHandlerModifiable createInventory() {
        return new ItemStackHandler(6);
    }

    public void fuse(PlayerEntity user) {
        float randomChance;
        FusionConfiguration.BreakChanceReduction reduction;
        IPlayerData data = PlayerData.getUnsafe(user);
        PerkConfiguration perkConfig = this.getPerkConfig();
        FusionConfiguration fusionConfig = perkConfig.getFusionConfig();
        int orbCount = (int)Arrays.stream(ORBS).mapToObj(num -> this.itemHandler.getStackInSlot(num)).filter(stack -> !stack.func_190926_b()).count();
        FusionConfiguration.Swap swapConfig = fusionConfig.getSwaps().getSwapStat(orbCount);
        Crystal crystal1 = CrystalItem.getCrystal(this.itemHandler.getStackInSlot(INPUTS[0]));
        Crystal crystal2 = CrystalItem.getCrystal(this.itemHandler.getStackInSlot(INPUTS[1]));
        int targetLevel = crystal1.getLevel() + crystal2.getLevel();
        FusionConfiguration.Upgrade upgrade = fusionConfig.getUpgrades().getUpgradeStat(targetLevel);
        FusionConfiguration.BreakChanceReductions reductions = fusionConfig.getBreakChanceReductions();
        int price = upgrade.getPrice() + swapConfig.getPrice();
        float breakChance = upgrade.getBreakChance();
        data.getPerkProvider().awardPoints(-price);
        Random random = this.field_145850_b.field_73012_v;
        EnumSet<PerkVariant> usedVariants = this.getCurrentlyUsedVariants();
        if (usedVariants.size() == 1 && (reduction = reductions.getReductionForOrbs(orbCount)) != null) {
            breakChance *= reduction.getMultiplier();
        }
        if ((randomChance = random.nextFloat()) < breakChance) {
            this.clearInputs();
            return;
        }
        ImmutableList variants = ImmutableList.copyOf(usedVariants);
        PerkVariant targetVariant = this.getTargetedOrbType();
        if (targetVariant == null) {
            targetVariant = (PerkVariant)((Object)variants.get(0));
        }
        PerkVariant other = variants.size() != 1 ? (PerkVariant)((Object)variants.get(1)) : targetVariant;
        targetVariant = random.nextFloat() < swapConfig.getChance() ? targetVariant : other;
        Crystal crystal = Crystal.mergeAndLevelUp(crystal1, crystal2, targetLevel);
        CrystalItem item = CrystalStationContainer.mapCrystalVariants().get((Object)targetVariant);
        ItemStack output = new ItemStack((IItemProvider)item);
        CrystalItem.addCrystal(output, crystal);
        this.itemHandler.setStackInSlot(0, output);
        this.clearInputs();
    }

    public boolean canFuse(PlayerEntity player) {
        boolean emptyOutput = this.itemHandler.getStackInSlot(0).func_190926_b();
        return emptyOutput && this.canFuseInputs() && this.checkFunds(player);
    }

    public boolean canAddItem(PerkVariant variant) {
        PerkVariant variant2;
        PerkVariant variant1;
        EnumSet<PerkVariant> set = this.getCrystalVariants();
        PerkVariant orbTarget = this.getTargetedOrbType();
        ItemStack item1 = this.itemHandler.getStackInSlot(INPUTS[0]);
        ItemStack item2 = this.itemHandler.getStackInSlot(INPUTS[1]);
        if (orbTarget != null) {
            return variant == orbTarget || set.contains((Object)orbTarget);
        }
        if (!item1.func_190926_b() && !item2.func_190926_b() && (variant1 = this.getItemVariant(item1)) == (variant2 = this.getItemVariant(item2)) && variant != variant1) {
            return false;
        }
        return set.size() < 2 || set.contains((Object)variant);
    }

    public PerkVariant getItemVariant(ItemStack stack) {
        return stack.func_190926_b() ? null : ((PerkItem)stack.func_77973_b()).getVariant();
    }

    public EnumSet<PerkVariant> getCrystalVariants() {
        EnumSet<PerkVariant> result = EnumSet.noneOf(PerkVariant.class);
        for (int slot : INPUTS) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            PerkVariant variant = this.getItemVariant(stack);
            if (variant == null) continue;
            result.add(variant);
        }
        return result;
    }

    public EnumSet<PerkVariant> getCurrentlyUsedVariants() {
        EnumSet<PerkVariant> result = EnumSet.noneOf(PerkVariant.class);
        for (int slot : INPUTS) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            PerkVariant variant = this.getItemVariant(stack);
            if (variant == null) continue;
            result.add(variant);
        }
        PerkVariant variant = this.getTargetedOrbType();
        if (variant != null) {
            result.add(variant);
        }
        return result;
    }

    private boolean checkFunds(PlayerEntity player) {
        IPlayerData data = PlayerData.getUnsafe(player);
        IPerkProvider provider = data.getPerkProvider();
        PerkConfiguration perkConfig = this.getPerkConfig();
        FusionConfiguration fusionConfig = perkConfig.getFusionConfig();
        int orbCount = (int)Arrays.stream(ORBS).mapToObj(num -> this.itemHandler.getStackInSlot(num)).filter(stack -> !stack.func_190926_b()).count();
        FusionConfiguration.Swap swapConfig = fusionConfig.getSwaps().getSwapStat(orbCount);
        Crystal crystal1 = CrystalItem.getCrystal(this.itemHandler.getStackInSlot(INPUTS[0]));
        Crystal crystal2 = CrystalItem.getCrystal(this.itemHandler.getStackInSlot(INPUTS[1]));
        int targetLevel = crystal1.getLevel() + crystal2.getLevel();
        FusionConfiguration.Upgrade upgrade = fusionConfig.getUpgrades().getUpgradeStat(targetLevel);
        int price = upgrade.getPrice() + swapConfig.getPrice();
        return provider.getPoints() >= price;
    }

    private boolean canFuseInputs() {
        ItemStack stack1 = this.itemHandler.getStackInSlot(INPUTS[0]);
        ItemStack stack2 = this.itemHandler.getStackInSlot(INPUTS[1]);
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        Crystal crystal1 = CrystalItem.getCrystal(stack1);
        Crystal crystal2 = CrystalItem.getCrystal(stack2);
        if (crystal1 == null || crystal2 == null) {
            return false;
        }
        int target = crystal1.getLevel() + crystal2.getLevel();
        FusionConfiguration.Upgrade upgrade = this.getPerkConfig().getFusionConfig().getUpgrades().getUpgradeStat(target);
        return upgrade != null;
    }

    private PerkConfiguration getPerkConfig() {
        return GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration();
    }

    public PerkVariant getTargetedOrbType() {
        for (int slot : ORBS) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            return this.getItemVariant(stack);
        }
        return null;
    }

    private void clearInputs() {
        for (int slot : INPUTS) {
            this.itemHandler.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        for (int slot : ORBS) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            stack.func_190918_g(1);
        }
    }
}

